REBOL [
    title: "ImmobilierNet Module agence - edition des affaires"
    version: 1.0
    author: "Olivier Auverlot"
]

affaires: make object! [

    edition-affaire: layout [
        backtile 192.192.192
        across
        text "Numro de dossier:"
        adossier: text 100
        astyle-bien: info 150 "" 
        button 50 "Style" [
            rep: request-list "Style du bien" styles-bien
            if not none? rep [
                astyle-bien/text: rep
                show astyle-bien
            ]
        ]
        avendue: check false [
            either avendue/data = false [
                aacheteur/text: copy ""
                show aacheteur
                numacheteur: 0
            ] [ 
                avendue/data: false 
                show avendue
            ]
        ]
        text "Affaire vendue" 
        return
        below
        guide 
        panel 250x300 [  
            origin 0x0         
            below
            text "Adresse :"
            aadr1: field 250 ""
            aadr2: field 250 ""
            across
            text "CP :"
            acp: field 60
            text "Ville :"
            aville: field 100 "" return  
            text "Prix :"
            aprix: field 60 ""
            text "Anne :"
            aannee: field 90 "" return
            text "Surface: "
            asurface: field 40 ""
            text "Terrain: "
            aterrain: field 90 "" return
            azonegeo: info 150 ""            
            button 80 "Zone" [
                rep: request-list "Zone gographique" zones                
                if not none? rep [
                    azonegeo/text: rep
                    show azonegeo
                ]
            ] return
            aacheteur: info 150 ""            
            button 80 "Acheteur" [
                envoi-sql "SELECT num,nom,prenom FROM clients ORDER BY nom"
                cles-clients: copy []
                donnees: copy []
                foreach ligne buffer [ 
                    append donnees rejoin [ 
                        (trim ligne/2) " " (trim ligne/3)
                    ]
                    append cles-clients ligne/1
                ]   
                rep: request-list "Clients" donnees
                if not none? rep [
                    numacheteur: pick cles-clients (where donnees rep)                
                    aacheteur/text: rep
                    show aacheteur                    
                    avendue/data: true
                    show avendue
                ]
            ] return          
            below
        ]
        return
        panel 250x160 [
            origin 0x0         
            across
            text "Chambres :"
            achambres: field 100 "" return
            atoiture: info 150 ""            
            button 80 "Toiture" [
                rep: request-list "Type de toiture" toitures
                if not none? rep [
                    atoiture/text: rep
                    show atoiture
                ]
            ] return          
            amur: info 150 ""            
            button 80 "Murs" [
                rep: request-list "Type des murs" murs
                if not none? rep [
                    amur/text: rep
                    show amur
                ]
            ] return          
            achauffage: info 150 ""            
            button 80 "Chauffage" [
                rep: request-list "Type de chauffage" chauffages
                if not none? rep [
                    achauffage/text: rep
                    show achauffage
                ]
            ] return          
            aetat: info 150 ""            
                button 80 "Etat" [
                rep: request-list "Etat du bien" etats
                if not none? rep [
                    aetat/text: rep
                    show aetat
                ]
            ] return               
        ]
        panel 250x140 [
            origin 0x0            
            aphoto: image 160x100 0.0.0 effect [ cross 255.255.255 ]
            across
            charge-photo: button "Photographie" [
                f: request-file/filter/title [ *.jpg *.bmp *.gif *.png ] "Slectionnez une photographie" "Valider"                
                if f <> none [
                    photo: first f
                    aphoto/effect: [ aspect ]
                    aphoto/image: load photo
                    show aphoto
                    fichier-photo: to-string second split-path photo
                ]
            ]
            button 50 "Vider" [
                aphoto/effect: [ cross 255.255.255 ]
                aphoto/image: none
                f: none
                fichier-photo: copy "none"
                show aphoto
            ]
        ]
        return
        panel 100x300 [
            origin 0x0
            across
            agarage: check text "Garage" return 
            aegout: check text "Egout" return
            aelectricite: check text "Electricit" return
            aeau: check text "Eau" return
            agaz: check text "Gaz" return
            asous-sol: check text "Sous-sol" return
            aetage: check text "Etage" return
            agrenier: check text "Grenier"           
        ]
        pad 30
        across
        button "Annuler" [ unview edition-affaire ]
        button "Valider" [ enregistre-affaire ]
    ]
    
    enregistre-affaire: does [        
        numstyle: where styles-bien (trim astyle-bien/text)
        numzone: where zones (trim azonegeo/text)
        numtoiture: where toitures (trim atoiture/text)
        nummur: where murs (trim amur/text)
        numchauffage: where chauffages (trim achauffage/text)
        numetat: where etats (trim aetat/text)        
        ; l'utilisateur a t'il slectionn un style et une zone gographique
        either all [ 
            (not none? numstyle)
            (not none? numzone)
            (not none? numtoiture)
            (not none? nummur)
            (not none? numchauffage)
            (not none? numetat)            
        ] [                                   
            either (none? num) [
                ; cration d'un dossier
                ; excution de la requte                                                                                  
                if error? try [
                    if f <> none [
                        write/binary (join ftp://olivier:auverlot@mars/immobiliernet/photos/ fichier-photo) read/binary to-file f
                    ]
                    envoi-sql join "INSERT INTO affaires " [
                        "(vendue,adr1,adr2,code_postal,ville,annee,prix,style,chambres,garage,toiture,murs,terrain,chauffage,surface,etat,egout,electricite,eau,gaz,etage,sous_sol,grenier,zonegeo,acheteur,photo)"
                        " values (" (to-integer avendue/data) ",'" aadr1/text "','" aadr2/text
                        "','" acp/text "','" aville/text "'," (to-integer trim aannee/text) ","
                        (to-integer trim aprix/text) "," (pick num-styles numstyle) "," (to-integer trim achambres/text) ","
                        (to-integer agarage/data) "," (pick num-toitures numtoiture) "," (pick num-murs nummur) ","
                        (to-integer trim aterrain/text) "," (pick num-chauffages numchauffage) "," (to-integer trim asurface/text) ","
                        (pick num-etats numetat) "," (to-integer aegout/data) "," (to-integer aelectricite/data) ","
                        (to-integer aeau/data) "," (to-integer agaz/data) "," (to-integer aetage/data) ","
                        (to-integer asous-sol/data) "," (to-integer agrenier/data) "," (pick num-zones numzone) ","
                        numacheteur ",'" fichier-photo "')"
                    ]
                    menu-principal/charge-table 2
                    unview edition-affaire
                ] [ request/ok "Certains champs ne sont pas correctement saisis" ]
            ] [
                ; modification d'un dossier                                                                                                                                                                                                                                                                                                                
                if error? try [                                                                                               
                    if f <> none [
                        write/binary (join ftp://olivier:auverlot@mars/immobiliernet/ fichier-photo) read/binary to-file f
                    ]
                    envoi-sql join "UPDATE affaires " [
                        "SET vendue=" (to-integer avendue/data) ","
                        "adr1='" aadr1/text "',"
                        "adr2='" aadr2/text "',"
                        "code_postal='" acp/text "',"
                        "ville='" aville/text "',"
                        "annee=" (to-integer trim aannee/text) ","
                        "prix=" (to-integer trim aprix/text) ","
                        "style=" (pick num-styles numstyle) ","
                        "chambres=" (to-integer trim achambres/text) ","
                        "garage=" (to-integer agarage/data) ","
                        "toiture=" (pick num-toitures numtoiture) ","
                        "murs=" (pick num-murs nummur) ","
                        "terrain=" (to-integer trim aterrain/text) ","
                        "chauffage=" (pick num-chauffages numchauffage) ","
                        "surface=" (to-integer trim asurface/text) ","
                        "etat=" (pick num-etats numetat) ","
                        "egout=" (to-integer aegout/data) ","
                        "electricite=" (to-integer aelectricite/data) ","
                        "eau=" (to-integer aeau/data) ","
                        "gaz=" (to-integer agaz/data) "," 
                        "etage=" (to-integer aetage/data) ","
                        "sous_sol=" (to-integer asous-sol/data) ","
                        "grenier=" (to-integer agrenier/data) ","
                        "zonegeo=" (pick num-zones numzone) ","
                        "acheteur=" numacheteur ","
                        "photo='" fichier-photo "'"                                
                        " WHERE num=" num
                    ] 
                    menu-principal/charge-table 2
                    unview edition-affaire
                ] [ request/ok "Certains champs ne sont pas correctement saisis" ]               
            ]
        ] [ request/ok "Certains champs n'ont pas t complts" ]
    ]
        
    start: function [ n ] [] [ 
        ; cl de l'affaire
        num: n
                
        styles-bien: copy [] 
        zones: copy []
        murs: copy []
        toitures: copy []
        etats: copy []
        chauffages: copy []
      
        ; chargement des styles
        envoi-sql "SELECT * FROM styles ORDER BY intitule" 
        ; stockage des cls primaires
        num-styles: copy []    
        foreach ele buffer [
            append num-styles (to-integer ele/1)
            append styles-bien (trim ele/2)
        ]
        
        ; chargement des zones
        envoi-sql "SELECT * FROM zonesgeo ORDER BY intitule"
        num-zones: copy []
        foreach ele buffer [
            append num-zones (to-integer ele/1)
            append zones (trim ele/2)
        ]
        
        ; chargement des murs
        envoi-sql "SELECT * FROM murs ORDER BY intitule"
        num-murs: copy []
        foreach ele buffer [
            append num-murs (to-integer ele/1)
            append murs (trim ele/2)
        ]
        
        ; chargement des toitures
        envoi-sql "SELECT * FROM toitures ORDER BY intitule"
        num-toitures: copy []
        foreach ele buffer [
            append num-toitures (to-integer ele/1)
            append toitures (trim ele/2)
        ]
        
        ; chargement des tats
        envoi-sql "SELECT * FROM etats ORDER BY intitule"
        num-etats: copy []
        foreach ele buffer [
            append num-etats (to-integer ele/1)
            append etats (trim ele/2)
        ]
        
        ; chargement des chauffages
        envoi-sql "SELECT * FROM chauffages ORDER BY intitule"
        num-chauffages: copy []
        foreach ele buffer [
            append num-chauffages (to-integer ele/1)
            append chauffages (trim ele/2)
        ]

        ; cration ou dition d'un dossier ?
        either not none? num [
            ; Edition
            adossier/text: num
            envoi-sql join "SELECT * FROM affaires WHERE num=" num
            avendue/data: to-logic buffer/1/2
            
            numstyle: make integer! buffer/1/9
            numtoiture: make integer! buffer/1/12
            nummur: make integer! buffer/1/13
            numchauffage: make integer! buffer/1/15
            numetat: make integer! buffer/1/17
            numzone: make integer! buffer/1/25
            numacheteur: make integer! buffer/1/26

            astyle-bien/text: pick styles-bien (where num-styles numstyle)
            azonegeo/text: pick zones (where num-zones numzone)
            atoiture/text: pick toitures (where num-toitures numtoiture)
            amur/text: pick murs (where num-murs nummur)
            achauffage/text: pick chauffages (where num-chauffages numchauffage)
            aetat/text: pick etats (where num-etats numetat)                      
            
            aadr1/text: buffer/1/3
            aadr2/text: buffer/1/4
            acp/text: to-string buffer/1/5
            aville/text: buffer/1/6
            aannee/text: to-string buffer/1/7
            aprix/text: to-string buffer/1/8
            asurface/text: to-string buffer/1/16
            aterrain/text: to-string buffer/1/14
            achambres/text: to-string buffer/1/10
            agarage/data: to-logic buffer/1/11
            aegout/data: to-logic buffer/1/18
            aelectricite/data: to-logic buffer/1/19
            aeau/data: to-logic buffer/1/20
            agaz/data: to-logic buffer/1/21
            aetage/data: to-logic buffer/1/22
            asous-sol/data: to-logic buffer/1/23
            agrenier/data: to-logic buffer/1/24          
            fichier-photo: to-string buffer/1/27
            f: none
            either (trim fichier-photo) <> "none" [
                aphoto/image: load read/binary join ftp://olivier:auverlot@mars/immobiliernet/ fichier-photo
                aphoto/effect: [ aspect ]
            ] [
                aphoto/image: none
                aphoto/effect: [ cross 255.255.255 ]
            ]
             
            ; si l'affaire est vendue, on cherche l'acheteur
            if numacheteur <> 0 [
                envoi-sql join "SELECT nom,prenom FROM clients WHERE num=" numacheteur
                aacheteur/text: copy buffer/1/1
            ] [ aacheteur/text: copy "" ]
        ] [
            ; cration
            adossier/text: "(nouveau)"
            astyle-bien/text: copy ""            
            avendue/data: false
            aadr1/text: copy ""
            aadr2/text: copy ""
            acp/text: copy ""
            aville/text: copy ""
            aprix/text: copy ""
            aannee/text: copy ""
            asurface/text: copy ""
            aterrain/text: copy ""
            azonegeo/text: copy ""
            aacheteur/text: copy ""
            achambres/text: copy ""
            atoiture/text: copy ""
            amur/text: copy ""
            achauffage/text: copy ""
            aetat/text: copy ""
            aphoto/image: none
            agarage/data: false
            aegout/data: false
            aelectricite/data: false
            aeau/data: false
            agaz/data: false
            asous-sol/data: false
            aetage/data: false
            agrenier/data: false                                  
            numacheteur: 0
            fichier-photo: copy "none"
            f: none
            aphoto/image: none
            aphoto/effect: [ cross 255.255.255 ]
        ]
        
        view/new edition-affaire
    ]
]
